/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.domain;

import eu.europa.ec.taxud.cesop.domain.ValidationResultTypeEnum;

public enum ValidationErrorTypeEnum {
    MH_BR_0010("10010", "MessageRefID is not unique.", ValidationResultTypeEnum.FULLY_REJECTED),
    MH_BR_0020("10020", "The 'Timestamp' element refers to a wrong value.", ValidationResultTypeEnum.FULLY_REJECTED),
    MH_BR_0030("10030", "The period is before 01/01/2024.", ValidationResultTypeEnum.FULLY_REJECTED),
    MH_BR_0040("10040", "Wrong CorrMessageRefID.", ValidationResultTypeEnum.FULLY_REJECTED),
    MH_BR_0050("10050", "Wrong format of the MessageRefID.", ValidationResultTypeEnum.FULLY_REJECTED),
    MH_BR_0060("10060", "Wrong format of the CorrMessageRefID.", ValidationResultTypeEnum.FULLY_REJECTED),
    MH_BR_0070("10070", "An initial Payment Data message can only contain new data.", ValidationResultTypeEnum.FULLY_REJECTED),
    MH_BR_0080("10080", "A correction message can only contain corrections and/or deletions.", ValidationResultTypeEnum.FULLY_REJECTED),
    MH_BR_0090("10090", "The message is not a payment data message.", ValidationResultTypeEnum.FULLY_REJECTED),
    MH_BR_0100("10100", "The reporting period cannot be updated.", ValidationResultTypeEnum.FULLY_REJECTED),
    MH_BR_0110("10110", "CorrMessageRefId wrongly used in MessageSpec.", ValidationResultTypeEnum.FULLY_REJECTED),
    MH_BR_0120("10120", "Wrong TransmittingCountry", ValidationResultTypeEnum.FULLY_REJECTED),
    CM_BR_0010("20010", "DocRefID is not unique within the message.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    CM_BR_0020("20020", "DocRefID is not unique within the system.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    CM_BR_0030("20030", "Wrong DocRefID format.", ValidationResultTypeEnum.FULLY_REJECTED),
    CM_BR_0040("20040", "Wrong CorrDocRefId value.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    CM_BR_0050("20050", "CorrDocRefId for new data.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    CM_BR_0060("20060", "Missing CorrDocRefId.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    CM_BR_0070("20070", "CorrDocRefId no longer valid.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    CM_BR_0100("20100", "Invalid PSP's BIC format.", ValidationResultTypeEnum.FULLY_REJECTED),
    CM_BR_0110("20110", "Missing ReportedPayee.", ValidationResultTypeEnum.FULLY_REJECTED),
    CM_BR_0120("20120", "CorrDocRefId does not belong to corrected message.", ValidationResultTypeEnum.FULLY_REJECTED),
    CM_BR_0130("20130", "Discrepancy in the provision of an 'other' type and its specification (full rejection).", ValidationResultTypeEnum.FULLY_REJECTED),
    CM_BR_0140("20140", "Discrepancy in the provision of an 'other' type and its specification (partial rejection).", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    CM_BR_0150("20150", "Same payee reported under two different ReportedPayee elements.", ValidationResultTypeEnum.FULLY_REJECTED),
    PS_BR_0010("30010", "Business identifier of the Representative is equal to the Business Identifier of the Reporting PSP.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RP_BR_0010("40010", "The reported transaction does not represent cross-border payment.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RP_BR_0020("40020", "Wrong IBAN format.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RP_BR_0030("40030", "IBAN is not valid.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RP_BR_0040("40040", "ReportedPayee listed in the No payment data for the requested period message.", ValidationResultTypeEnum.FULLY_REJECTED),
    RP_BR_0050("40050", "The 'ReportedTransaction' element is missing.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RP_BR_0060("40060", "Discrepancy in the 'AccountIdentifier' attributes.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RP_BR_0070("40070", "Invalid Representative's BIC format.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RP_BR_0080("40080", "Discrepancy between 'AccountIdentifier' and 'Representative'.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RP_BR_0090("40090", "The 'ReportedTransaction' element is present.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RP_BR_0100("40100", "Invalid account identifier(s) for the same reported payee.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RP_BR_0110("40110", "IBAN, BIC or OBAN reported in the accountIdentifierOther element.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RT_BR_0010("45010", "Wrong value of the 'IsRefund' element in the 'AmountCurrency' element.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RT_BR_0030("45030", "None of the 'DateTime' elements refers to a date within the reporting period.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RT_BR_0040("45040", "The 'TransactionIdentifier' element is not unique within the Payment data message.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RT_BR_0050("45050", "The 'TransactionIdentifier' element is not unique within the system.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RT_BR_0060("45060", "Zero value for 'Amount' element.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RT_BR_0080("45080", "Same transaction date provided more than once.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    RT_BR_0090("45090", "Wrong value of the 'IsRefund' element while CorrTransactionIdentifier is provided.", ValidationResultTypeEnum.PARTIALLY_REJECTED),
    CM_TR_0010("50010", "The XML message is not well formed.", ValidationResultTypeEnum.FULLY_REJECTED),
    CM_TR_0020("50020", "Failed Decryption.", ValidationResultTypeEnum.FULLY_REJECTED),
    CM_TR_0030("50030", "Failed Decompression.", ValidationResultTypeEnum.FULLY_REJECTED),
    CM_TR_0040("50040", "Failed Signature Check.", ValidationResultTypeEnum.FULLY_REJECTED),
    CM_TR_0050("50050", "Failed Threat Scan.", ValidationResultTypeEnum.FULLY_REJECTED),
    CM_TR_0060("50060", "Failed Virus Scan.", ValidationResultTypeEnum.FULLY_REJECTED),
    CM_TR_0070("50070", "Message size exceeded.", ValidationResultTypeEnum.FULLY_REJECTED),
    CM_TR_0080("50080", "Too many errors detected.", ValidationResultTypeEnum.FULLY_REJECTED),
    CM_TR_9999("99999", "Custom error.", ValidationResultTypeEnum.FULLY_REJECTED);

    private final String code;
    private final String description;
    private final ValidationResultTypeEnum resultType;

    private ValidationErrorTypeEnum(String code, String description, ValidationResultTypeEnum resultType) {
        this.code = code;
        this.description = description;
        this.resultType = resultType;
    }

    public static boolean isSupported(ValidationErrorTypeEnum errorCode, String xsdVersion) {
        switch (errorCode) {
            case MH_BR_0120: {
                return Double.parseDouble(xsdVersion) >= 4.01;
            }
            case CM_BR_0150: 
            case RT_BR_0090: {
                return Double.parseDouble(xsdVersion) >= 4.03;
            }
        }
        return true;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public ValidationResultTypeEnum getResultType() {
        return this.resultType;
    }
}

